/**
 * Footer override script to remove EspoCRM copyright and show only Codak copyright
 */
(function () {
    'use strict';

    // Function to remove EspoCRM copyright
    function removeEspoCopyright() {
        // Look for the footer and remove EspoCRM text
        const footers = document.querySelectorAll('footer');
        footers.forEach(footer => {
            const paragraphs = footer.querySelectorAll('p.credit');
            paragraphs.forEach(p => {
                // Check if the paragraph contains EspoCRM text
                if (p.textContent.includes('EspoCRM') || p.textContent.includes('2025')) {
                    // Replace with Codak copyright
                    p.innerHTML = '&copy; 2026 Codak';
                }
            });

            // Also check for any links to EspoCRM website
            const links = footer.querySelectorAll('a[href*="espocrm"]');
            links.forEach(link => {
                link.parentNode.removeChild(link);
            });
        });

        // Also check document for any other instances of EspoCRM copyright
        const allParagraphs = document.querySelectorAll('p');
        allParagraphs.forEach(p => {
            if (p.textContent.includes('EspoCRM') && p.textContent.includes('2025')) {
                p.innerHTML = '&copy; 2026 Codak';
            }
        });
    }

    // Run immediately
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', removeEspoCopyright);
    } else {
        removeEspoCopyright();
    }

    // Run periodically to catch any dynamically added content
    setInterval(removeEspoCopyright, 100);

    // Enhanced MutationObserver to watch for changes
    const observer = new MutationObserver(function (mutations) {
        mutations.forEach(function (mutation) {
            if (mutation.type === 'childList') {
                removeEspoCopyright();
            }
        });
    });

    // Observe changes in the body
    observer.observe(document.body, {
        childList: true,
        subtree: true
    });
})();